

#asm
(main)test.asm

_DKDRV  EQU    $6049
_DKOPC  EQU    $6048
_DKTRK  EQU    $604B
_DKVAL  EQU    $6052
_DKSEC  EQU    $604C
_DKERR  EQU    $604E

	ORG    $8000				| debut de l'impementation en 9000 
	ORCC   #$50 				|    Gel des interruptions

	TFR	   S,Y				    | store old S
	STY    $62FE

	LDA    #$60     			| Fixe le
	TFR    A,DP     			| DP a $60
	LDS    #$6600-_GLOBALS 		| share 6300-6400 for stack and globals
	TFR	   S,Y				| Y is GLOBAL pointer

	CLR    $6019    			| Plus dinterruptions
	CLRB
	STB    _DKDRV     			| drive 0

	LDX	   #$6300
	STX    $604F 	  			| sector buffer		  
#endasm



/* le main doit être en premier */

int
main() {
	int ii,i,j,k;

	char *longname;
	int longOff;
	int longIdx;

	int nfic;
	int dirEnd;

	int t;
	int piste;

	char *p;
	char *buf;
	char *buf2; /* big dir buffer in A000 enough for 127 entries */

	int ret;
	char c;
	char s2;
	int cfgnum;

	/* LBA, MBR and all (V)FAT stuff */
    unsigned int lbaBeg_h;
    unsigned int lbaBeg_l;
	unsigned int f_clusz;
	unsigned int f_shift;
	unsigned int f_res;

	unsigned int f_nbfat;

	unsigned int f_fatsh;
	unsigned int f_fatsl;

	unsigned int f_rooth;
	unsigned int f_rootl;

	unsigned int f_firsth;
	unsigned int f_firstl;

	unsigned int f_tmph;
	unsigned int f_tmpl;

	unsigned int f_cfgh;
	unsigned int f_cfgl;
    unsigned int idx;

	int page,select,maxpage;
	
	border(0);

	cls();

	cfgnum=-1;

	i=0x6300;buf=i;
	i=0xA000;buf2=i;
	i=(0xAFFF-17);longname=i;
	

	i=0x604E;p=i;*p=0; /* clear error */
	ret=go_trk255(); 
	border(1);
	border(2);

	ret=string(0,0,"Checking Host mode...",21);
	ret=rd_sec(0); 
	ret=dump16b(22,0,ret); 
	
	if (buf[0]!='H') {
		string(0,2,"Fatal cannot setup Host mode...",31);
		while (1==1) ;
	}

	string(0,1,buf,8);
	string(8,1,buf+8,12);

	ret=rd_lba(0,0);
	lbaBeg_l=mk_16(buf[446+9],buf[446+8]); 
	lbaBeg_h=mk_16(buf[446+11],buf[446+10]);

/*
	dump16b(0,17,lbaBeg_h);
	dump16b(4,17,lbaBeg_l);
*/
	rd_lba(lbaBeg_h,lbaBeg_l);

	/* get all fat stuf */
	f_clusz=buf[0x0D];
	f_shift=siz2shif(f_clusz);
	f_res=mk_16(buf[0x0F],buf[0x0E]);
	f_nbfat=buf[0x10];
	f_fatsl=mk_16(buf[0x25],buf[0x24]);
	f_fatsh=mk_16(buf[0x27],buf[0x26]);
	f_rootl=mk_16(buf[0x2D],buf[0x2C]);
	f_rooth=mk_16(buf[0x2F],buf[0x2E]);
	
/*
	dump16b(0,18,f_rooth);
	dump16b(4,18,f_rootl);
*/

	/* (unsigned long)cluster_begin_lba = Partition_LBA_Begin + Number_of_Reserved_Sectors + (Number_of_FATs * Sectors_Per_FAT); */
	add_32(lbaBeg_h,lbaBeg_l,0,f_res,&f_firsth,&f_firstl);

	for (i=0;i<f_nbfat;i++) {
		add_32(f_firsth,f_firstl,f_fatsh,f_fatsl,&f_firsth,&f_firstl);
	}
/*	
	dump16b(0,19,f_firsth);
	dump16b(4,19,f_firstl);
*/

	/* address = lba_start+((clust-2)*size) */ 
	sub_32(f_rooth,f_rootl,0,2,&f_tmph,&f_tmpl); /* clu-2 */
	clu2lba(f_tmph,f_tmpl,f_shift,&f_tmph,&f_tmpl); /* *size */
	add_32(f_firsth,f_firstl,f_tmph,f_tmpl,&f_tmph,&f_tmpl); /* + lba_start */

/*
	dump16b(0,20,f_tmph);
	dump16b(4,20,f_tmpl);

	dump16b(10,18,f_clusz);
	dump16b(14,18,f_shift);
*/



	nfic=0;
	longname[0]='\0';
	longname[13]='\0';

	border(3);

	dirEnd=0;

	for (ii=0;ii<f_clusz;ii++) {
		if (dirEnd==1) {
			break;
		}
		/* read the directory sector */
		rd_lba(f_tmph,f_tmpl);
			
		for (i=0;i<16;i++) {
            idx=i<<5;
			if ((buf[idx]&0xFF)==0x00) {
				dirEnd=1;
				 break;
			}
			if ((buf[idx+11]&0x0F)==0x0F) {
				longIdx=buf[idx]&0xF;
				longOff=(longIdx-1)*13;
				for (j=0;j<5;j++) {
					if (longOff+j<17) {
						k=(idx)+(j<<1)+1;
						longname[longOff+j]=buf[k];
					}
				}
				for (j=0;j<6;j++) {
					if (longOff+j+5<17) {
						k=(idx)+(j<<1)+0xE;
						longname[longOff+j+5]=buf[k];
					}
				}
				for (j=0;j<2;j++) {
					if (longOff+j+11<17) {
						k=(idx)+(j<<1)+0x1C;
						longname[longOff+j+11]=buf[k];
					}
				}	
				continue; /* skip long filenames */
			}

			if ((buf[idx]&0xFF)!=0xE5) {
				for (j=0;j<8;j++) {
					buf2[(nfic<<5)+j]=buf[(i<<5)+j];
				}	
				for (j=0;j<3;j++) {
					buf2[(nfic<<5)+j+8]=buf[(i<<5)+j+8];
				}	
				for (j=0;j<14;j++) {
					buf2[(nfic<<5)+11+j]=longname[j];
				}
				longname[0]='\0';
				longname[13]='\0';
				
				/* also copy first cluster */
				buf2[(nfic<<5)+31]=buf[(i<<5)+0x1A];
				buf2[(nfic<<5)+30]=buf[(i<<5)+0x1B];
				buf2[(nfic<<5)+29]=buf[(i<<5)+0x14];
				buf2[(nfic<<5)+28]=buf[(i<<5)+0x15];
                
                
				/* also copy 3 bytes of size */
				buf2[(nfic<<5)+27]=buf[(i<<5)+0x1C];
				buf2[(nfic<<5)+26]=buf[(i<<5)+0x1D];
				buf2[(nfic<<5)+25]=buf[(i<<5)+0x1E];
                
				nfic++;
				if (nfic>126) {
					dirEnd=1;
					break;
				}
			} else {
				longname[0]='\0';
				longname[13]='\0';
			}
		}
		add_32(f_tmph,f_tmpl,0x0000,0x0001,&f_tmph,&f_tmpl); /* increment LBA */
	
	}

	border(0);

	banner();
	for (i=0;i<nfic;i++) {
		if (find83("HXCSDFE CFG",&buf2[i<<5])==0) {
			string(0,22,"Found cfg:",10);
			dump16b(11,22,i);
			cfgnum=i;
			f_cfgh=mk_16(buf2[(cfgnum<<5)+28],buf2[(cfgnum<<5)+29]);
			f_cfgl=mk_16(buf2[(cfgnum<<5)+30],buf2[(cfgnum<<5)+31]);
			break;
		}
	}


	select=0;
	page=0;
	maxpage=((nfic-1)>>4);
	fic_list(select,page,nfic);
	hi_line(select+4,0xC7);

	while (1) {
		i=getc();
		dump16b(0,24,i);
		if ((i==0x08) && (page>0)) {
			page--;
			hi_line(select+4,0xF8);
			select=0;
			fic_list(select,page,nfic);
			hi_line(select+4,0xC7);
		}
		if ((i==0x09) && (page<maxpage)) {
			page++;
			hi_line(select+4,0xF8);
			select=0;
			fic_list(select,page,nfic);
			hi_line(select+4,0xC7);
		}
		if ((i==0x0B) && (select>0)) {
			hi_line(select+4,0xF8);
			select--;
			hi_line(select+4,0xC7);
		} 
		else 
		if ((i==0x0B) && (page>0)) {
			page--;
			hi_line(select+4,0xF8);
			select=15;
			fic_list(select,page,nfic);
			hi_line(select+4,0xC7);			
		}
 		
		if ((i==0x0A) && (select<15)) {
			hi_line(select+4,0xF8);
			if ((page<<4)+select+1<nfic) {
				select++;
			}
			hi_line(select+4,0xC7);
		}
		else
		if ((i==0x0A) && (page<maxpage)) {
			page++;
			hi_line(select+4,0xF8);
			select=0;
			fic_list(select,page,nfic);
			hi_line(select+4,0xC7);
		}
		if (i==0x0D)  {

			if (cfgnum==-1) {
				cls();
				string(0,2,"fatal missing CFG",17);
				k=getc();
				cls();
				banner();
				fic_list(select,page,nfic);
			
				continue;
			}
			if (f_clusz<2) {
				cls();
				string(0,2,"cluster size 1 is unsupported..",33);
				k=getc();
				cls();
				banner();
				fic_list(select,page,nfic);
			
				continue;
			}
			cls();
			string(0,2,"Confirm loading of file ? (y/n)",31);
			
			j=(page<<4)+select;
			string(1,4,&buf2[j<<5],8);
			charxy(8,4,'.');
			string(10,4,&buf2[(j<<5)+8],3);
			string(14,4,&buf2[(j<<5)+11],17);

			k=getc();
			if ((k==0x79) || (k==0x59)) {
				/* go */
				/* read config first sector */
				/* address = lba_start+((clust-2)*size) */ 
				sub_32(f_cfgh,f_cfgl,0,2,&f_tmph,&f_tmpl); /* clu-2 */
				clu2lba(f_tmph,f_tmpl,f_shift,&f_tmph,&f_tmpl); /* *size */
				add_32(f_firsth,f_firstl,f_tmph,f_tmpl,&f_tmph,&f_tmpl); /* + lba_start */
				
				rd_lba(f_tmph,f_tmpl);
				string(0,5,"CFG SECTOR0",11);
				buf[22]=0x02;
				buf[23]=0x01;
				
				ret=wt_sec(1);

				
				string(0,5,&buf[0],32);
				add_32(f_tmph,f_tmpl,0x0000,0x0001,&f_tmph,&f_tmpl); /* increment LBA */

				string(0,6,"CFG SECTOR1",11);
				rd_lba(f_tmph,f_tmpl);
				string(0,7,&buf[0],11);string(12,7,&buf[21],14);

				for (ii=0;ii<11;ii++) {
					buf[ii]=buf2[(j<<5)+ii];
				}
				buf[11]='\0';
				buf[12]='\0';
				buf[13]=buf2[(j<<5)+31];
				buf[14]=buf2[(j<<5)+30];
				buf[15]=buf2[(j<<5)+29];
				buf[16]=buf2[(j<<5)+28];

				/* fixed size for HFE thomson */
				buf[17]=0x00;
				buf[18]=0xA4;
				buf[19]=0x1E;
				buf[20]=0x00;										
				for (ii=0;ii<14;ii++) {
					buf[21+ii]=buf2[(j<<5)+ii+11];
				}
				buf[37]='\0';
				for (ii=38;ii<0x40;ii++) {
					buf[ii]='\0';
				}
				
				/* just write back sector (LBA is still correct) */
				ret=wt_sec(1);
				dump16b(0,24,ret);
				string(0,8,"WRT SECTOR1",11);
				string(0,9,&buf[0],11);string(12,9,&buf[21],14);

				/* just write back sector (LBA is still correct) */
				ret=rd_sec(1);
				dump16b(0,24,ret);
				string(0,10,"READ BACK SECTOR1",17);
				string(0,11,&buf[0],11);string(12,11,&buf[21],14);


				add_32(f_tmph,f_tmpl,0x0000,0x0001,&f_tmph,&f_tmpl); /* increment LBA */
				rd_lba(f_tmph,f_tmpl);

				for (ii=0;ii<11;ii++) {
					buf[ii+0x80]=buf2[(j<<5)+ii];
				}
				buf[11+0x80]='\0';
				buf[12+0x80]='\0';
				buf[13+0x80]=buf2[(j<<5)+31];
				buf[14+0x80]=buf2[(j<<5)+30];
				buf[15+0x80]=buf2[(j<<5)+29];
				buf[16+0x80]=buf2[(j<<5)+28];

				/* fixed size for HFE thomson */
				buf[17+0x80]=buf2[(j<<5)+27];
				buf[18+0x80]=buf2[(j<<5)+26];
				buf[19+0x80]=buf2[(j<<5)+25];
				buf[20+0x80]=0x00;										
				for (ii=0;ii<14;ii++) {
					buf[21+ii+0x80]=buf2[(j<<5)+ii+11];
				}
				buf[37+0x80]='\0';
				for (ii=38;ii<0x40;ii++) {
					buf[ii]='\0';
				}
				
				/* just write back sector (LBA is still correct) */
				ret=wt_sec(1);
				dump16b(0,24,ret);

/*				string(0,13,"Press a key...",14);

				k=getc();
*/
				string(0,14,"Leaving host...",15);
				
				leave_lba();
				/* also seek just in case... () */
				go_track(0);


				string(0,15,"... REBOOT ...",10);
				/* and reset */
				{
#asm
        TFR    S,Y
        STY    $62FC
		LDY    $62FE
		TFR	   Y,S

		JMP	[$FFFE]
#endasm
				}

			}
			cls();
			banner();
			fic_list(select,page,nfic);
		
		}
		
	}
	return 0;
}
cls()
{
	set_col();
	fill(0xF8);
	set_pt();
	fill(0x00);
	return 0;
}
banner()
{
	string(0,0,"HxC TO File selector by VitalMotion",37);
	string(0,2,"Select your File:\0",17);
	return 0;
}

fic_list(select,page,nfic)
int select;
int page;
int nfic;
{
	int i,j;
    int idx;
	int start;
	int line;
	char *buf2;

	i=0xA000;buf2=i;
	
	start=(page<<4);
	
	line=0;
	for (i=start;i<(start+16);i++) {
        idx=i<<5;
		if (i>=nfic) {
			string(1,line+4,"                                       ",39);
			line++;
			continue;
		}

		string(1,line+4,&buf2[idx],8);
		charxy(9,line+4,'.');
		string(10,line+4,&buf2[(idx)+8],3);

		string(14,line+4,&buf2[(idx)+11],14);
		
		dump16b(32,line+4,mk_16(0,buf2[(idx)+25]));
		dump16b(36,line+4,mk_16(buf2[(idx)+26],buf2[(idx)+27]));
		line++;
	}
	return 0;
}
/*
 cfg is
 * 


struct ShortDirectoryEntry {
	unsigned char name[12];
	unsigned char attributes;
	unsigned long firstCluster;
	unsigned long size;
	unsigned char longName[17];	// boolean
};

extern struct DirectoryEntry directoryEntry;


typedef struct disk_in_drive_
{
	struct ShortDirectoryEntry DirEnt;
	unsigned char numberoftrack;
	unsigned char numberofside;
	unsigned short rpm;
	unsigned short bitrate;
	unsigned short tracklistoffset;
}disk_in_drive;
 
 at 0x100 (in first LBA sector)
 * 
*/
string(x,y,s,sz)
int x;
int y;
char *s;
int sz;
{
	int i;
	int ii;
	for (i=0;i<sz;i++) {
		if (s[i]=='\0') {
			for (ii=i;ii<sz;ii++) {
				charxy(x,y,' ');
				x++;
			}
			break;
		}
		charxy(x,y,s[i]);
		x++;
	}
	return 0;
}


find83(s1,s2)
char *s1;
char *s2;
{
	int i;
	int ret;
	ret=0;
	for (i=0;i<11;i++) {
		if (s1[i]!=s2[i]) {
			ret=1;
			break;
		}
	}
	return ret;
}

char hexchar(c)
char c;
{
	if (c<10) { return '0'+c; }
	return 'A'+c-10;
}

dump16b(x,y,v)
int x;
int y;
unsigned int v;
{
	unsigned int ii,jj;
	jj=(v&0xF000)>>12;
	ii=hexchar(jj);
	charxy(x,y,ii);
	jj=(v&0xF00)>>8;
	ii=hexchar(jj);
	charxy(x+1,y,ii);
	jj=(v&0xF0)>>4;
	ii=hexchar(jj);
	charxy(x+2,y,ii);
	jj=v&0xF;
	ii=hexchar(jj);
	charxy(x+3,y,ii);
	return 0;
}

go_trk255()
{
{
#asm
		LDA    #$01     | reset lecteur
		STA    _DKOPC
		JSR    $E004
		LDA    #$20     | rech piste 0
		STA    _DKOPC
		JSR    $E004
		CLR    _DKVAL
		LDA    #$02     | read a sector to start motor 
		STA    _DKTRK
		LDA    #$01     | read a sector to start motor 
		STB    _DKSEC
		LDA    #$02
		STA    _DKOPC
		LDA    #127     | goto 127
		STA    _DKTRK
		LDA    #$40
		STA    _DKOPC
		JSR    $E004
		CLR    _DKVAL
		LDA    #127      | 127 more...
		STA    _DKTRK
		LDA    #$40
		STA    _DKOPC
		JSR    $E004
		CLR    _DKVAL
		LDA    #1        | 1 more...
		STA    _DKTRK
		LDA    #$40
		STA    _DKOPC
		JSR    $E004
		LDA	   #$FF
		STA    _DKVAL    | make monitor think we are in track 255
		STA    _DKTRK	
		LDA	   #$00
		LDB    _DKERR
		TFR     D,X      | return in X
#endasm
}
	return 0;
}

go_track(track)
char track; 
{
{
#asm
		LDA	$E000
		CMPA	#$44 		| for WD floppy (ie TO9)
		BNE	go_norm

		LDA	#$FF
		STA	$6051
		LDA    #127      | try to go -128 tracks...
		STA    _DKVAL
		CLR    _DKTRK
		LDA    #$40
		JSR    $E004
		
go_norm
		LDA    #$20     | rech piste 0
		STA    _DKOPC
		JSR    $E004
		CLR    _DKVAL
    	LDB	    5,U
		STB    _DKTRK
		LDA    #$40
		STA    _DKOPC
		JSR    $E004
		LDA	   #$00
		LDB    _DKERR
		TFR     D,X      | return in X		
#endasm
}
}

rd_lba(high,low)
unsigned int high,low;
{
	int i;
	char *p;

	for (i=0x6300;i<0x6500;i++) {
		p=i;
		*p=0x00;
	}
	i=0x6300;p=i;
	p[0]='H';
	p[1]='x';
	p[2]='C';
	p[3]='F';
	p[4]='E';
	p[5]='D';
	p[6]='A';
	p[7]=0;

	p[8]=0x01;
	p[9]=(low & 0xFF);
	p[10]=((low >> 8) & 0xFF);
	p[11]=(high & 0xFF);
	p[12]=((high >> 8) & 0xFF);
	p[13]=0xA5;
	p[14]=0x08;

	/* init fields with a read */
	wt_sec(0);
	i=rd_sec(1);
	return i;
}

leave_lba(v)
int v;
{
	int i;
	char *p;

	for (i=0x6300;i<0x6500;i++) {
		p=i;
		*p=0x00;
	}
	i=0x6300;p=i;
	p[0]='H';
	p[1]='x';
	p[2]='C';
	p[3]='F';
	p[4]='E';
	p[5]='D';
	p[6]='A';
	p[7]=0;

	p[8]=0x02;
	p[9]=0x00;
	p[10]=0x00;

	/* init fields with a read */
	wt_sec(0);
	i=rd_sec(1);
	return i;
}

mk_16(c1,c2)
char c1;
char c2;
{
{
#asm
		LDA    5,U             | read from stack
		LDB    7,U             | read from stack
		TFR    D,X             | return in X		
#endasm
}
}

add_32(h1,l1,h2,l2,rh,rl)
unsigned int h1,l1;
unsigned int h2,l2;
unsigned int *rh,*rl;
{
{
#asm
		LEAX   4,U             | h1
		LEAY   8,U             | h2
                ANDCC  #$FE
		LDA    3,X
                ADCA   3,Y
		STA    3,Y
		LDA    2,X
                ADCA   2,Y
		STA    2,Y
		LDA    1,X
                ADCA   1,Y
		STA    1,Y
		LDA    ,X
                ADCA   ,Y
		STA    ,Y

		LDX    8,U
		STX    [12,U]            | rh 

		LDX    10,U
		STX    [14,U]            | rl 
#endasm
}
}

sub_32(h1,l1,h2,l2,rh,rl)
unsigned int h1,l1;
unsigned int h2,l2;
unsigned int *rh,*rl;
{
{
#asm
		LEAX   4,U             | h1
		LEAY   8,U             | h2
                ANDCC  #$FE
		LDA    3,X
                SBCA   3,Y
		STA    3,Y
		LDA    2,X
                SBCA   2,Y
		STA    2,Y
		LDA    1,X
                SBCA   1,Y
		STA    1,Y
		LDA    ,X
                SBCA   ,Y
		STA    ,Y

		LDX    8,U
		STX    [12,U]            | rh 

		LDX    10,U
		STX    [14,U]            | rl 
#endasm
}
}
siz2shif(sz)
int sz;
{
	int i;
	switch (sz) {
		case 1 : i=0;
		break;
		case 2 : i=1;
		break;
		case 4 : i=2;
		break;
		case 8 : i=3;
		break;
		case 16 : i=4;
		break;
		case 32 : i=5;
		break;
		case 64 : i=6;
		break;
		case 128 : i=7;
		break;
	        default : i=0;
	}
	return i;
}

clu2lba(h,l,shift,rh,rl)
unsigned int h,l;
unsigned int shift;
unsigned int *rh,*rl;
{
{
#asm
		LEAX   4,U             | h (+l)

		LDB    9,U	       | shift
L_CLU2LBA
		CMPB   #$00
		BEQ    L_CLU2END
                ANDCC  #$FE

		LDA    3,X
		LSLA
		STA    3,X
		LDA    2,X
		ROLA
		STA    2,X
		LDA    1,X
                ROLA
		STA    1,X
		LDA    ,X
                ROLA
		STA    ,X
		DECB
		BRA L_CLU2LBA

L_CLU2END
		LDX    4,U
		STX    [10,U]            | rh 

		LDX    6,U
		STX    [12,U]            | rl 
#endasm
}
}

/*
 * Physical read/write in 9sect/512byte
 */

rd_sec(sect) 
char sect;
{
{
#asm
		LDB    5,U             | read from stack
		LDA    #$02            | read sector (monitor)
		STA    _DKOPC
		STB    _DKSEC
		PSHS   U,DP
		LDX    #$6300
		STX    $604F           | sector buffer

		LDA	$E000
		CMPA	#$44		| for WD floppy (ie TO9)
		BNE	rd_TO8
		CLR	$6051
		LDA    #$FF
		STA    $E7D1
		LDA    #$02
		STA    _DKOPC
		JSR    $E004
		BRA    rd_sect_end

rd_TO8
		LDA    #$02            | read sector (monitor)
		JSR    $789D
		JSR    $78A7
		PSHS   A	       | 
		JSR    $7C5A           | activate drive...
		JSR    $7965	       | wait some time
		JSR    $7CA8
		LDA    #$FF
		STA    6,X             | force track FF in THFMC reg
		JSR    $7BAE
		PULS   A               | E0EE
		JSR    $78B9           | motor off
rd_sect_end
		PULS   DP,U		
		LDA    #$00
		LDB    _DKERR

		TFR    D,X             | return in X		
#endasm
}
}

wt_sec(sect) 
char sect;
{
{
#asm
		LDB    5,U             | read from stack
		LDA    #$08            | read sector (monitor)
		STA    _DKOPC
		STB    _DKSEC
		PSHS   U,DP
		LDX    #$6300
		STX    $604F           | sector buffer	

		LDA	$E000
		CMPA	#$44 		| for WD floppy (ie TO9)
		BNE	wt_TO8
		CLR	$6051
		LDA    #$FF
		STA    $E7D1
		LDA    #$08
		STA    _DKOPC
		JSR    $E004
		BRA    wt_sect_end

wt_TO8

		LDA    #$08            | read sector (monitor)
		JSR    $789D
		JSR    $78A7
		PSHS   A	       | 
		JSR    $7C5A           | activate drive...
		JSR    $7965	       | wait some time
		JSR    $7CA8
		LDA    #$FF
		STA    6,X             | force track FF in THFMC reg
		JSR    $797A
		PULS   A               | E0EE
		JSR    $78B9           | motor off
wt_sect_end
		PULS   DP,U		
		LDA    #$00
		LDB    _DKERR
		TFR    D,X             | return in X		
#endasm
}
}


getc() 
{
{
#asm     
        TFR    S,Y
        STY    $62FC
		LDY    $62FE
		TFR	   Y,S

        ANDCC  #$EF

L_GETC

		JSR    $E806           | call monitor
		BCC    L_GETC

        ORCC   #$50
						
        TFR    S,Y
        STY    $62FE
		LDY    $62FC
		TFR    Y,S
		
				
		LDA    #$00
		TFR    D,X             | return in X		
				
	
#endasm
}
}
fill(v)
char v;
{
{
#asm
	LDB	   5,U
	LDX    #$4000
FILL_L
	STB    ,X+
	CMPX   #$5F40
	BNE    FILL_L  
#endasm
}
}



set_resolution(res) 
char res;
{
{
#asm
	LDB	5,U
	STB	$E7DC
#endasm
}
}


set_pt() 
{
{
#asm
	LDB	#$01
	ORB	$E7C3
	STB	$E7C3
#endasm
}
}

set_col() 
{
{
#asm
	LDB	#$FE
	ANDB	$E7C3
	STB	$E7C3
#endasm
}
}

border(idx)
int idx; 
{
{
#asm
	LDB	#$F0
	ANDB	$E7E4
	ORB	5,U
	STB	$E7DD
#endasm
}
}

hi_line(l,c)
int l;
int c;
{
	set_col(); 
{
#asm
* screen base address is x+y*40*8 -> Y
	LDB 5,U
	LSLB 
	LDX #BASE_TXT_ADR
	LEAX [B,X]
	LDB 7,U
	LDY #320
L_HILINE
	STB ,X+
	
	LEAY -1,Y
	CMPY	#$0000
	BNE    L_HILINE
#endasm
}
	set_pt();
}

charxy(x,y,c)
char x;
char y;
char c;
{
{
#asm
* screen base address is x+y*40*8 -> Y
	LDB 7,U
	LSLB 
	LDX #BASE_TXT_ADR
	LEAX [B,X]
	LDB 5,U
	ABX
	TFR	X,Y

* font base is font adress + 8*c -> X
	LDB	9,U
	ANDB #$7F
	LDX #FONT8
	LDA	#8 
	MUL
	LEAX D,X  

* put a byte every 40 screen byte
	LDB	#40
	LDA	,X+
	STA	,Y
	LEAY B,Y
	LDA	,X+
	STA	,Y
	LEAY B,Y
	LDA	,X+
	STA	,Y
	LEAY B,Y
	LDA	,X+
	STA	,Y
	LEAY B,Y
	LDA	,X+
	STA	,Y
	LEAY B,Y
	LDA	,X+
	STA	,Y
	LEAY B,Y
	LDA	,X+
	STA	,Y
	LEAY B,Y
	LDA	,X+
	STA	,Y
        
    PULS U,PC	; retour de fonction compatible mini C                

* MC09 internal functions/lib
	
_00001	PSHS	D,X,Y		multiply
	
	LDA	,S
	LDB	3,S
	MUL
	STB	4,S
	
	LDD	1,S
	MUL
	STB	5,S
	
	LDA	1,S
	LDB	3,S
	MUL
	ADDA	4,S
	ADDA	5,S
	
	LEAS	6,S
	RTS
	
_00006	CMPX	#0		signed left shift
	BMI	_06001
 
_06000	BEQ	_06009
	LSLB
	ROLA
	LEAX	-1,X
	BRA	_06000
	
_06001	BEQ	_06009
	ASRA
	RORB
	LEAX	1,X
	BRA	_06001
	
_06009	RTS
_00008	CMPX	#0		sined right shift
	BMI	_08001
	
_08000	BEQ	_08009
	ASRA
	RORB
	LEAX	-1,X
	BRA	_08000
	
_08001	BEQ	_08009
	LSLB
	ROLA
	LEAX	1,X
	BRA	_08001
	
_08009	RTS	
_00009	CMPX	#0		unsined right shift
	BMI	_09001
	
_09000	BEQ	_09009
	LSRA
	RORB
	LEAX	-1,X
	BRA	_09000
	
_09001	BEQ	_09009
	LSLB
	ROLA
	LEAX	1,X
	BRA	_09001
	
_09009	RTS	
	
BASE_TXT_ADR
	FDB	0+$4000
	FDB	1*40*8+$4000
	FDB	2*40*8+$4000
	FDB	3*40*8+$4000
	FDB	4*40*8+$4000
	FDB	5*40*8+$4000
	FDB 6*40*8+$4000
	FDB	7*40*8+$4000
	FDB	8*40*8+$4000
	FDB	9*40*8+$4000
	FDB	10*40*8+$4000
	FDB	11*40*8+$4000
	FDB	12*40*8+$4000
	FDB	13*40*8+$4000
	FDB	14*40*8+$4000
	FDB	15*40*8+$4000
	FDB	16*40*8+$4000
	FDB	17*40*8+$4000
	FDB	18*40*8+$4000
	FDB	19*40*8+$4000
	FDB	20*40*8+$4000
	FDB	21*40*8+$4000
	FDB	22*40*8+$4000
	FDB	23*40*8+$4000
	FDB	24*40*8+$4000

FONT8		
	FCB	$0,$0,$0,$0,$0,$0,$0,$0
	FCB	$7E,$81,$A5,$81,$BD,$99,$81,$7E
	FCB	$7E,$FF,$DB,$FF,$C3,$E7,$FF,$7E
	FCB	$6C,$FE,$FE,$FE,$7C,$38,$10,$0
	FCB	$10,$38,$7C,$FE,$7C,$38,$10,$0
	FCB	$38,$7C,$38,$FE,$FE,$D6,$10,$38
	FCB	$10,$10,$38,$7C,$FE,$7C,$10,$38
	FCB	$0,$0,$18,$3C,$3C,$18,$0,$0
	FCB	$FF,$FF,$E7,$C3,$C3,$E7,$FF,$FF
	FCB	$0,$3C,$66,$42,$42,$66,$3C,$0
	FCB	$FF,$C3,$99,$BD,$BD,$99,$C3,$FF
	FCB	$F,$3,$5,$7D,$84,$84,$84,$78
	FCB	$3C,$42,$42,$42,$3C,$18,$7E,$18
	FCB	$3F,$21,$3F,$20,$20,$60,$E0,$C0
	FCB	$3F,$21,$3F,$21,$23,$67,$E6,$C0
	FCB	$18,$DB,$3C,$E7,$E7,$3C,$DB,$18
	FCB	$80,$E0,$F8,$FE,$F8,$E0,$80,$0
	FCB	$2,$E,$3E,$FE,$3E,$E,$2,$0
	FCB	$18,$3C,$7E,$18,$18,$7E,$3C,$18
	FCB	$24,$24,$24,$24,$24,$0,$24,$0
	FCB	$7F,$92,$92,$72,$12,$12,$12,$0
	FCB	$3E,$63,$38,$44,$44,$38,$CC,$78
	FCB	$0,$0,$0,$0,$7E,$7E,$7E,$0
	FCB	$18,$3C,$7E,$18,$7E,$3C,$18,$FF
	FCB	$10,$38,$7C,$54,$10,$10,$10,$0
	FCB	$10,$10,$10,$54,$7C,$38,$10,$0
	FCB	$0,$18,$C,$FE,$C,$18,$0,$0
	FCB	$0,$30,$60,$FE,$60,$30,$0,$0
	FCB	$0,$0,$40,$40,$40,$7E,$0,$0
	FCB	$0,$24,$66,$FF,$66,$24,$0,$0
	FCB	$0,$10,$38,$7C,$FE,$FE,$0,$0
	FCB	$0,$FE,$FE,$7C,$38,$10,$0,$0
	FCB	$0,$0,$0,$0,$0,$0,$0,$0
	FCB	$10,$38,$38,$10,$10,$0,$10,$0
	FCB	$24,$24,$24,$0,$0,$0,$0,$0
	FCB	$24,$24,$7E,$24,$7E,$24,$24,$0
	FCB	$18,$3E,$40,$3C,$2,$7C,$18,$0
	FCB	$0,$62,$64,$8,$10,$26,$46,$0
	FCB	$30,$48,$30,$56,$88,$88,$76,$0
	FCB	$10,$10,$20,$0,$0,$0,$0,$0
	FCB	$10,$20,$40,$40,$40,$20,$10,$0
	FCB	$20,$10,$8,$8,$8,$10,$20,$0
	FCB	$0,$44,$38,$FE,$38,$44,$0,$0
	FCB	$0,$10,$10,$7C,$10,$10,$0,$0
	FCB	$0,$0,$0,$0,$0,$10,$10,$20
	FCB	$0,$0,$0,$7E,$0,$0,$0,$0
	FCB	$0,$0,$0,$0,$0,$10,$10,$0
	FCB	$0,$2,$4,$8,$10,$20,$40,$0
	FCB	$3C,$42,$46,$4A,$52,$62,$3C,$0
	FCB	$10,$30,$50,$10,$10,$10,$7C,$0
	FCB	$3C,$42,$2,$C,$30,$42,$7E,$0
	FCB	$3C,$42,$2,$1C,$2,$42,$3C,$0
	FCB	$8,$18,$28,$48,$FE,$8,$1C,$0
	FCB	$7E,$40,$7C,$2,$2,$42,$3C,$0
	FCB	$1C,$20,$40,$7C,$42,$42,$3C,$0
	FCB	$7E,$42,$4,$8,$10,$10,$10,$0
	FCB	$3C,$42,$42,$3C,$42,$42,$3C,$0
	FCB	$3C,$42,$42,$3E,$2,$4,$38,$0
	FCB	$0,$10,$10,$0,$0,$10,$10,$0
	FCB	$0,$10,$10,$0,$0,$10,$10,$20
	FCB	$8,$10,$20,$40,$20,$10,$8,$0
	FCB	$0,$0,$7E,$0,$0,$7E,$0,$0
	FCB	$10,$8,$4,$2,$4,$8,$10,$0
	FCB	$3C,$42,$2,$4,$8,$0,$8,$0
	FCB	$3C,$42,$5E,$52,$5E,$40,$3C,$0
	FCB	$18,$24,$42,$42,$7E,$42,$42,$0
	FCB	$7C,$22,$22,$3C,$22,$22,$7C,$0
	FCB	$1C,$22,$40,$40,$40,$22,$1C,$0
	FCB	$78,$24,$22,$22,$22,$24,$78,$0
	FCB	$7E,$22,$28,$38,$28,$22,$7E,$0
	FCB	$7E,$22,$28,$38,$28,$20,$70,$0
	FCB	$1C,$22,$40,$40,$4E,$22,$1E,$0
	FCB	$42,$42,$42,$7E,$42,$42,$42,$0
	FCB	$38,$10,$10,$10,$10,$10,$38,$0
	FCB	$E,$4,$4,$4,$44,$44,$38,$0
	FCB	$62,$24,$28,$30,$28,$24,$63,$0
	FCB	$70,$20,$20,$20,$20,$22,$7E,$0
	FCB	$63,$55,$49,$41,$41,$41,$41,$0
	FCB	$62,$52,$4A,$46,$42,$42,$42,$0
	FCB	$18,$24,$42,$42,$42,$24,$18,$0
	FCB	$7C,$22,$22,$3C,$20,$20,$70,$0
	FCB	$3C,$42,$42,$42,$4A,$3C,$3,$0
	FCB	$7C,$22,$22,$3C,$28,$24,$72,$0
	FCB	$3C,$42,$40,$3C,$2,$42,$3C,$0
	FCB	$7F,$49,$8,$8,$8,$8,$1C,$0
	FCB	$42,$42,$42,$42,$42,$42,$3C,$0
	FCB	$41,$41,$41,$41,$22,$14,$8,$0
	FCB	$41,$41,$41,$49,$49,$49,$36,$0
	FCB	$41,$22,$14,$8,$14,$22,$41,$0
	FCB	$41,$22,$14,$8,$8,$8,$1C,$0
	FCB	$7F,$42,$4,$8,$10,$21,$7F,$0
	FCB	$78,$40,$40,$40,$40,$40,$78,$0
	FCB	$80,$40,$20,$10,$8,$4,$2,$0
	FCB	$78,$8,$8,$8,$8,$8,$78,$0
	FCB	$10,$28,$44,$82,$0,$0,$0,$0
	FCB	$0,$0,$0,$0,$0,$0,$0,$FF
	FCB	$10,$10,$8,$0,$0,$0,$0,$0
	FCB	$0,$0,$3C,$2,$3E,$42,$3F,$0
	FCB	$60,$20,$20,$2E,$31,$31,$2E,$0
	FCB	$0,$0,$3C,$42,$40,$42,$3C,$0
	FCB	$6,$2,$2,$3A,$46,$46,$3B,$0
	FCB	$0,$0,$3C,$42,$7E,$40,$3C,$0
	FCB	$C,$12,$10,$38,$10,$10,$38,$0
	FCB	$0,$0,$3D,$42,$42,$3E,$2,$7C
	FCB	$60,$20,$2C,$32,$22,$22,$62,$0
	FCB	$10,$0,$30,$10,$10,$10,$38,$0
	FCB	$2,$0,$6,$2,$2,$42,$42,$3C
	FCB	$60,$20,$24,$28,$30,$28,$26,$0
	FCB	$30,$10,$10,$10,$10,$10,$38,$0
	FCB	$0,$0,$76,$49,$49,$49,$49,$0
	FCB	$0,$0,$5C,$62,$42,$42,$42,$0
	FCB	$0,$0,$3C,$42,$42,$42,$3C,$0
	FCB	$0,$0,$6C,$32,$32,$2C,$20,$70
	FCB	$0,$0,$36,$4C,$4C,$34,$4,$E
	FCB	$0,$0,$6C,$32,$22,$20,$70,$0
	FCB	$0,$0,$3E,$40,$3C,$2,$7C,$0
	FCB	$10,$10,$7C,$10,$10,$12,$C,$0
	FCB	$0,$0,$42,$42,$42,$46,$3A,$0
	FCB	$0,$0,$41,$41,$22,$14,$8,$0
	FCB	$0,$0,$41,$49,$49,$49,$36,$0
	FCB	$0,$0,$44,$28,$10,$28,$44,$0
	FCB	$0,$0,$42,$42,$42,$3E,$2,$7C
	FCB	$0,$0,$7C,$8,$10,$20,$7C,$0
	FCB	$C,$10,$10,$60,$10,$10,$C,$0
	FCB	$10,$10,$10,$0,$10,$10,$10,$0
	FCB	$30,$8,$8,$6,$8,$8,$30,$0
	FCB	$32,$4C,$0,$0,$0,$0,$0,$0
	FCB	$0,$8,$14,$22,$41,$41,$7F,$0


#endasm	
}
}
